<?php  
/* 
Plugin Name: VC Polygon Surface Background
Version: 1.2
Author: Boom-Apps
Author URI: http://codecanyon.net/user/boom-apps
Description: Flat Surface Shader backgrounds for Visual Composer
*/  

class VC_PolygonSurface {
	function backendElement() {
		vc_map( array(
            "name" => __("VC Polygon Surface", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_polygonsurface",
            "class" => "",
            "controls" => "full",
            "params" => array(
              array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcpolygonsurface_".time()."_".rand(100000,999999999) )
			)
        ) );
		
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "colorpicker",  "group" => "Mesh", "class" => "", "heading" => "Ambient color", "param_name" => "mesh_ambient", "value" => "#555555" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "colorpicker",  "group" => "Mesh", "class" => "", "heading" => "Diffuse color", "param_name" => "mesh_diffuse", "value" => "#FFFFFF" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Width", "param_name" => "mesh_width", "value" => "1.2", "description" => "Float (0.1 - 2.0)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Height", "param_name" => "mesh_height", "value" => "1.2", "description" => "Float (0.1 - 2.0)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Depth", "param_name" => "mesh_depth", "value" => "20", "description" => "Integer (0 - 50)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Segments", "param_name" => "mesh_segments", "value" => "15", "description" => "Integer (1 - 20)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Slices", "param_name" => "mesh_slices", "value" => "8", "description" => "Integer (1 - 20)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "X Range", "param_name" => "mesh_xrange", "value" => "0.3", "description" => "Float (0.0 - 1.0)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Y Range", "param_name" => "mesh_yrange", "value" => "0.3", "description" => "Float (0.0 - 1.0)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Mesh", "class" => "", "heading" => "Speed", "param_name" => "mesh_speed", "value" => "0.0002", "description" => "Float (0.0000 - 0.0100)" ));
		
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "dropdown",  "group" => "Light", "class" => "", "heading" => "Animate", "param_name" => "light_autopilot", "value" =>  array( "Yes" => "true", "No" => "false") ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "colorpicker",  "group" => "Light", "class" => "", "heading" => "Ambient color", "param_name" => "light_ambient", "value" => "#8800FF" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "colorpicker",  "group" => "Light", "class" => "", "heading" => "Diffuse color", "param_name" => "light_diffuse", "value" => "#FF8800" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Light", "class" => "", "heading" => "Count", "param_name" => "light_count", "value" => "2", "description" => "Integer (1 - 5)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Light", "class" => "", "heading" => "Z Offset", "param_name" => "light_zoffset", "value" => "200", "description" => "Integer (0 - 500)" ));
		vc_add_param("vc_polygonsurface", array( "save_always" => true, "type" => "textarea",  "group" => "Light", "class" => "", "heading" => "Speed", "param_name" => "light_speed", "value" => "0.0010", "description" => "Float (0.0000 - 0.0100)" ));

	}
	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','flat-surface-shader','vc_polygonsurface' ) );
		wp_enqueue_style(  array( 'vc_polygonsurface' ) );
		
		$Return = '<div id="'.$Atts['theid'].'" ';
		foreach ($Atts as $AttN => $AttV) {
			$Return .= 'data-'.str_replace("_","-",$AttN).'="'.$AttV.'" ';
		}
		$Return .= 'class="vc-polygonsurface-background" style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	function registerStuff() {
		add_shortcode( 'vc_polygonsurface', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( 'vc_polygonsurface', plugins_url('vcpolygonsurface.js',__FILE__ ) );
		 wp_register_style( 'vc_polygonsurface', plugins_url('vcpolygonsurface.css',__FILE__ ) );
		 wp_register_script( 'flat-surface-shader', plugins_url('_3rdparty/flat-surface-shader/fss.min.js',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_PolygonSurface;
}

